-- Define our particle characteristics
pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member

pAge = Allocate(1) ; -- Allocate a Vec2 velocity member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member
pStartRed = Allocate(1) ;
pStartGreen = Allocate(1) ;
pStartBlue = Allocate(1) ;

-- Set the particle texture
SetTexture("flower");
SetBlendMode(kBlendNormal);

SetNumParticles(8);    -- Create some particles

pStartRed:Init(fRange(0,1));
pStartGreen:Init(fRange(0,1));
pStartBlue:Init(fRange(0,1));
pPosition:Init(  Vec2(0,0) );
pVelocity:Init( fRange( Vec2(-50,-100), Vec2(50,-120) ) );

pScale:Init( 0.5 );
pSpin:Init( fRange( 0, 1.5 ) );
pSpinSpeed:Init( fRange( -5, 5 ) );

pColor:Init( Color(pStartRed, pStartGreen, pStartBlue, 1) );

pUp:Anim( f2dRotation( pSpin ) );

kLifetime = 1000;
pColor:Anim( fFade( pAge,Color(pStartRed, pStartGreen, pStartBlue, 1), kLifetime/2, Color(pStartRed, pStartGreen, pStartBlue,1), kLifetime, Color(pStartRed, pStartGreen, pStartBlue,0)) );
pPosition:Anim( pPosition + fTimeScale(pVelocity) );
pPosition:Anim( pPosition );
pScale:Anim( pScale + fTimeScale(1) );
pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,120)) );
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

-- Add time to the age
pAge:Anim( pAge+fAge() );

-- Expire particles over 1500 ms old
Anim( fExpire( fGreater(pAge,kLifetime) ) );

-- Variable to control emission
gEmitParticles = true;


-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
   -- Create 10 particles per second
   if gEmitParticles then
      if mytimer == nil then
         mytimer = NewTimeout(1);
     elseif not mytimer(seconds) then 
         CreateParticles( seconds * 10 );
    else
         gEmitParticles = false;
         mytimer = nil;
    end
   end
end

